<?php
namespace Happy_Addons\Elementor;

defined( 'ABSPATH' ) || die();

class Icons_Manager {

    public static function init() {
        add_filter( 'elementor/icons_manager/additional_tabs', [ __CLASS__, 'add_happy_icons_tab' ] );
    }

    public static function add_happy_icons_tab( $tabs ) {
        $tabs['happy-icons'] = [
            'name' => 'happy-icons',
            'label' => __( 'Happy Icons', 'happy-elementor-addons' ),
            'url' => HAPPY_ADDONS_ASSETS . 'fonts/style.min.css',
            'enqueue' => [ HAPPY_ADDONS_ASSETS . 'fonts/style.min.css' ],
            'prefix' => 'hm-',
            'displayPrefix' => 'hm',
            'labelIcon' => 'hm hm-happyaddons',
            'ver' => HAPPY_ADDONS_VERSION,
            'fetchJson' => HAPPY_ADDONS_ASSETS . 'fonts/happy-icons.js?v=' . HAPPY_ADDONS_VERSION,
            'native' => false,
        ];
        return $tabs;
    }

    /**
     * Get a list of happy icons
     *
     * @return array
     */
    public static function get_happy_icons() {
        return [
            'hm hm-3d-rotate' => '3d-rotate',
            'hm hm-degree' => 'degree',
            'hm hm-accordion-horizontal' => 'accordion-horizontal',
            'hm hm-accordion-vertical' => 'accordion-vertical',
            'hm hm-alarm-clock' => 'alarm-clock',
            'hm hm-alien-gun' => 'alien-gun',
            'hm hm-alien' => 'alien',
            'hm hm-anchor' => 'anchor',
            'hm hm-android' => 'android',
            'hm hm-angle-down' => 'angle-down',
            'hm hm-angle-left' => 'angle-left',
            'hm hm-angle-right' => 'angle-right',
            'hm hm-angle-up' => 'angle-up',
            'hm hm-apple' => 'apple',
            'hm hm-arrow-left' => 'arrow-left',
            'hm hm-arrow-right' => 'arrow-right',
            'hm hm-arrow-zoom-out' => 'arrow-zoom-out',
            'hm hm-arrow-corner' => 'arrow-corner',
            'hm hm-arrow-down' => 'arrow-down',
            'hm hm-arrow-left1' => 'arrow-left1',
            'hm hm-arrow-right1' => 'arrow-right1',
            'hm hm-arrow-up' => 'arrow-up',
            'hm hm-article' => 'article',
            'hm hm-avatar-man' => 'avatar-man',
            'hm hm-avatar-woman' => 'avatar-woman',
            'hm hm-badge1' => 'badge1',
            'hm hm-badge2' => 'badge2',
            'hm hm-badge3' => 'badge3',
            'hm hm-bamboo' => 'bamboo',
            'hm hm-basketball' => 'basketball',
            'hm hm-battery' => 'battery',
            'hm hm-beach-seat' => 'beach-seat',
            'hm hm-bell' => 'bell',
            'hm hm-bicycle' => 'bicycle',
            'hm hm-blog-content' => 'blog-content',
            'hm hm-bluetooth' => 'bluetooth',
            'hm hm-board' => 'board',
            'hm hm-body' => 'body',
            'hm hm-bomb' => 'bomb',
            'hm hm-bond-hand' => 'bond-hand',
            'hm hm-bond' => 'bond',
            'hm hm-bonsai' => 'bonsai',
            'hm hm-book' => 'book',
            'hm hm-bowl' => 'bowl',
            'hm hm-brick-wall' => 'brick-wall',
            'hm hm-brush-paint' => 'brush-paint',
            'hm hm-brush-roll' => 'brush-roll',
            'hm hm-brush' => 'brush',
            'hm hm-bug' => 'bug',
            'hm hm-bulb' => 'bulb',
            'hm hm-calculation' => 'calculation',
            'hm hm-calendar' => 'calendar',
            'hm hm-camera' => 'camera',
            'hm hm-candle' => 'candle',
            'hm hm-candles' => 'candles',
            'hm hm-car' => 'car',
            'hm hm-card' => 'card',
            'hm hm-caret-down' => 'caret-down',
            'hm hm-caret-fill-down' => 'caret-fill-down',
            'hm hm-caret-fill-left' => 'caret-fill-left',
            'hm hm-caret-fill-right' => 'caret-fill-right',
            'hm hm-caret-fill-up' => 'caret-fill-up',
            'hm hm-caret-left' => 'caret-left',
            'hm hm-caret-right' => 'caret-right',
            'hm hm-caret-up' => 'caret-up',
            'hm hm-carousal' => 'carousal',
            'hm hm-cart-empty' => 'cart-empty',
            'hm hm-cart-full' => 'cart-full',
            'hm hm-caution' => 'caution',
            'hm hm-chair' => 'chair',
            'hm hm-chair2' => 'chair2',
            'hm hm-chat-bubble-single' => 'chat-bubble-single',
            'hm hm-chat-bubble' => 'chat-bubble',
            'hm hm-cheese' => 'cheese',
            'hm hm-chef-cap' => 'chef-cap',
            'hm hm-clip-board' => 'clip-board',
            'hm hm-clip' => 'clip',
            'hm hm-cloud-down' => 'cloud-down',
            'hm hm-cloud-up' => 'cloud-up',
            'hm hm-cloud' => 'cloud',
            'hm hm-code-browser' => 'code-browser',
            'hm hm-code-clean' => 'code-clean',
            'hm hm-code' => 'code',
            'hm hm-cog' => 'cog',
            'hm hm-color-card' => 'color-card',
            'hm hm-color-plate' => 'color-plate',
            'hm hm-compass-math' => 'compass-math',
            'hm hm-compass' => 'compass',
            'hm hm-corner' => 'corner',
            'hm hm-crop' => 'crop',
            'hm hm-cross-circle' => 'cross-circle',
            'hm hm-cross-game' => 'cross-game',
            'hm hm-cross-gap' => 'cross-gap',
            'hm hm-cross' => 'cross',
            'hm hm-crown' => 'crown',
            'hm hm-cube' => 'cube',
            'hm hm-cup-coffee' => 'cup-coffee',
            'hm hm-cup' => 'cup',
            'hm hm-currency-paper' => 'currency-paper',
            'hm hm-dashboard' => 'dashboard',
            'hm hm-delivery-van' => 'delivery-van',
            'hm hm-diamond-ring' => 'diamond-ring',
            'hm hm-direction-both' => 'direction-both',
            'hm hm-direction-right' => 'direction-right',
            'hm hm-disable-person' => 'disable-person',
            'hm hm-disc' => 'disc',
            'hm hm-dislike' => 'dislike',
            'hm hm-dollar-on-hand' => 'dollar-on-hand',
            'hm hm-door-path' => 'door-path',
            'hm hm-Download-circle' => 'Download-circle',
            'hm hm-download' => 'download',
            'hm hm-drag-inside' => 'drag-inside',
            'hm hm-drag-outside' => 'drag-outside',
            'hm hm-drag' => 'drag',
            'hm hm-drawer' => 'drawer',
            'hm hm-dribbble' => 'dribbble',
            'hm hm-dropper' => 'dropper',
            'hm hm-egg-fry' => 'egg-fry',
            'hm hm-ellipsis-fill-h' => 'ellipsis-fill-h',
            'hm hm-ellipsis-fill-v' => 'ellipsis-fill-v',
            'hm hm-ellipsis-horizontal' => 'ellipsis-horizontal',
            'hm hm-ellipsis-vertical' => 'ellipsis-vertical',
            'hm hm-emo-normal' => 'emo-normal',
            'hm hm-emo-sad' => 'emo-sad',
            'hm hm-emo-smile' => 'emo-smile',
            'hm hm-envelop' => 'envelop',
            'hm hm-facebook' => 'facebook',
            'hm hm-fancy-futton' => 'fancy-futton',
            'hm hm-feeder' => 'feeder',
            'hm hm-file-cabinet' => 'file-cabinet',
            'hm hm-file-rotate' => 'file-rotate',
            'hm hm-file' => 'file',
            'hm hm-files' => 'files',
            'hm hm-film-roll' => 'film-roll',
            'hm hm-film' => 'film',
            'hm hm-finger-index' => 'finger-index',
            'hm hm-finger-print' => 'finger-print',
            'hm hm-fire-flame' => 'fire-flame',
            'hm hm-flag' => 'flag',
            'hm hm-flip-card1' => 'flip-card1',
            'hm hm-flip-card2' => 'flip-card2',
            'hm hm-folder-network' => 'folder-network',
            'hm hm-folder' => 'folder',
            'hm hm-football' => 'football',
            'hm hm-footer' => 'footer',
            'hm hm-form' => 'form',
            'hm hm-forward' => 'forward',
            'hm hm-fountain-pen' => 'fountain-pen',
            'hm hm-gender-female' => 'gender-female',
            'hm hm-gender-male' => 'gender-male',
            'hm hm-gender-sign' => 'gender-sign',
            'hm hm-gender' => 'gender',
            'hm hm-ghost' => 'ghost',
            'hm hm-gift-box' => 'gift-box',
            'hm hm-globe1' => 'globe1',
            'hm hm-globe2' => 'globe2',
            'hm hm-globe3' => 'globe3',
            'hm hm-globe4' => 'globe4',
            'hm hm-google' => 'google',
            'hm hm-graduate-cap' => 'graduate-cap',
            'hm hm-graph-bar' => 'graph-bar',
            'hm hm-graph-pie' => 'graph-pie',
            'hm hm-graph' => 'graph',
            'hm hm-grid-even' => 'grid-even',
            'hm hm-grid-masonry' => 'grid-masonry',
            'hm hm-grid-twist' => 'grid-twist',
            'hm hm-grid' => 'grid',
            'hm hm-group' => 'group',
            'hm hm-hand-mike' => 'hand-mike',
            'hm hm-hand-watch' => 'hand-watch',
            'hm hm-hand' => 'hand',
            'hm hm-header' => 'header',
            'hm hm-headphone' => 'headphone',
            'hm hm-headset' => 'headset',
            'hm hm-heart-beat' => 'heart-beat',
            'hm hm-hexa' => 'hexa',
            'hm hm-highlighter' => 'highlighter',
            'hm hm-home' => 'home',
            'hm hm-hot-spot' => 'hot-spot',
            'hm hm-hotdog' => 'hotdog',
            'hm hm-ice-cream' => 'ice-cream',
            'hm hm-icon-box' => 'icon-box',
            'hm hm-imac' => 'imac',
            'hm hm-image-compare' => 'image-compare',
            'hm hm-image-slider' => 'image-slider',
            'hm hm-image' => 'image',
            'hm hm-inbox' => 'inbox',
            'hm hm-infinity' => 'infinity',
            'hm hm-info' => 'info',
            'hm hm-injection' => 'injection',
            'hm hm-instagram' => 'instagram',
            'hm hm-jar-chemical' => 'jar-chemical',
            'hm hm-key' => 'key',
            'hm hm-language-change' => 'language-change',
            'hm hm-laptop' => 'laptop',
            'hm hm-layer' => 'layer',
            'hm hm-lens' => 'lens',
            'hm hm-like' => 'like',
            'hm hm-line-graph-pointed' => 'line-graph-pointed',
            'hm hm-link' => 'link',
            'hm hm-linkedin' => 'linkedin',
            'hm hm-linux' => 'linux',
            'hm hm-list-2' => 'list-2',
            'hm hm-list-group' => 'list-group',
            'hm hm-list' => 'list',
            'hm hm-location-pointer' => 'location-pointer',
            'hm hm-lock' => 'lock',
            'hm hm-logo-carousel' => 'logo-carousel',
            'hm hm-logo-grid' => 'logo-grid',
            'hm hm-lotus' => 'lotus',
            'hm hm-love' => 'love',
            'hm hm-madel' => 'madel',
            'hm hm-magic-wand' => 'magic-wand',
            'hm hm-magnet' => 'magnet',
            'hm hm-mail-open' => 'mail-open',
            'hm hm-man-range' => 'man-range',
            'hm hm-map-marker' => 'map-marker',
            'hm hm-map-pointer' => 'map-pointer',
            'hm hm-measurement' => 'measurement',
            'hm hm-memory' => 'memory',
            'hm hm-menu-price' => 'menu-price',
            'hm hm-micro-chip' => 'micro-chip',
            'hm hm-microphone1' => 'microphone1',
            'hm hm-microphone2' => 'microphone2',
            'hm hm-mobile' => 'mobile',
            'hm hm-money-bag' => 'money-bag',
            'hm hm-money' => 'money',
            'hm hm-monitor' => 'monitor',
            'hm hm-mouse' => 'mouse',
            'hm hm-muscle' => 'muscle',
            'hm hm-net' => 'net',
            'hm hm-network1' => 'network1',
            'hm hm-network2' => 'network2',
            'hm hm-newspaper' => 'newspaper',
            'hm hm-nuclear-circle' => 'nuclear-circle',
            'hm hm-office-file' => 'office-file',
            'hm hm-pacman' => 'pacman',
            'hm hm-paper-fold' => 'paper-fold',
            'hm hm-paper-plane-alt' => 'paper-plane-alt',
            'hm hm-paper-plane' => 'paper-plane',
            'hm hm-pause' => 'pause',
            'hm hm-pen-head' => 'pen-head',
            'hm hm-pen-pencil' => 'pen-pencil',
            'hm hm-pen-scale' => 'pen-scale',
            'hm hm-pen-paper' => 'pen-paper',
            'hm hm-pen' => 'pen',
            'hm hm-pencil' => 'pencil',
            'hm hm-pendrive' => 'pendrive',
            'hm hm-phone' => 'phone',
            'hm hm-pillar' => 'pillar',
            'hm hm-pin-man-range' => 'pin-man-range',
            'hm hm-pin-man' => 'pin-man',
            'hm hm-pin' => 'pin',
            'hm hm-plane' => 'plane',
            'hm hm-play-end' => 'play-end',
            'hm hm-play-next' => 'play-next',
            'hm hm-play-previous' => 'play-previous',
            'hm hm-play-start' => 'play-start',
            'hm hm-play-button' => 'play-button',
            'hm hm-play-store' => 'play-store',
            'hm hm-play' => 'play',
            'hm hm-playing-card' => 'playing-card',
            'hm hm-plus-box' => 'plus-box',
            'hm hm-plus-circle' => 'plus-circle',
            'hm hm-plus-gap' => 'plus-gap',
            'hm hm-plus-open' => 'plus-open',
            'hm hm-popup' => 'popup',
            'hm hm-power' => 'power',
            'hm hm-printer' => 'printer',
            'hm hm-progress-bar' => 'progress-bar',
            'hm hm-promo' => 'promo',
            'hm hm-pulse' => 'pulse',
            'hm hm-puzzle' => 'puzzle',
            'hm hm-question' => 'question',
            'hm hm-quote' => 'quote',
            'hm hm-radar' => 'radar',
            'hm hm-radiation' => 'radiation',
            'hm hm-reading-glass-alt' => 'reading-glass-alt',
            'hm hm-reading-glass' => 'reading-glass',
            'hm hm-recycle-bin' => 'recycle-bin',
            'hm hm-recycle' => 'recycle',
            'hm hm-refresh-time' => 'refresh-time',
            'hm hm-reply' => 'reply',
            'hm hm-responsive-device' => 'responsive-device',
            'hm hm-review' => 'review',
            'hm hm-rocket1' => 'rocket1',
            'hm hm-rocket2' => 'rocket2',
            'hm hm-rss' => 'rss',
            'hm hm-safety-cap' => 'safety-cap',
            'hm hm-safety-kit' => 'safety-kit',
            'hm hm-sand-watch' => 'sand-watch',
            'hm hm-scale' => 'scale',
            'hm hm-scanner' => 'scanner',
            'hm hm-scissor' => 'scissor',
            'hm hm-screen' => 'screen',
            'hm hm-search' => 'search',
            'hm hm-seo' => 'seo',
            'hm hm-server-network' => 'server-network',
            'hm hm-server' => 'server',
            'hm hm-share' => 'share',
            'hm hm-shield' => 'shield',
            'hm hm-ship' => 'ship',
            'hm hm-shirt' => 'shirt',
            'hm hm-shopping-bag1' => 'shopping-bag1',
            'hm hm-shopping-bag2' => 'shopping-bag2',
            'hm hm-shopping-bag3' => 'shopping-bag3',
            'hm hm-shopping-bag4' => 'shopping-bag4',
            'hm hm-shuffle' => 'shuffle',
            'hm hm-shutter' => 'shutter',
            'hm hm-sign-in' => 'sign-in',
            'hm hm-sign-out' => 'sign-out',
            'hm hm-sitemap1' => 'sitemap1',
            'hm hm-sitemap2' => 'sitemap2',
            'hm hm-skart' => 'skart',
            'hm hm-skull' => 'skull',
            'hm hm-skyscraper' => 'skyscraper',
            'hm hm-slider-doc' => 'slider-doc',
            'hm hm-slider-h-range' => 'slider-h-range',
            'hm hm-slider-image' => 'slider-image',
            'hm hm-slider-range-h' => 'slider-range-h',
            'hm hm-slider-v-open' => 'slider-v-open',
            'hm hm-slider-video' => 'slider-video',
            'hm hm-slider' => 'slider',
            'hm hm-smart-watch' => 'smart-watch',
            'hm hm-snow' => 'snow',
            'hm hm-spa-face' => 'spa-face',
            'hm hm-spa-stone-flower' => 'spa-stone-flower',
            'hm hm-spa-stone' => 'spa-stone',
            'hm hm-spark' => 'spark',
            'hm hm-speaker-off' => 'speaker-off',
            'hm hm-speaker-on' => 'speaker-on',
            'hm hm-spoon-fork' => 'spoon-fork',
            'hm hm-spoon' => 'spoon',
            'hm hm-star' => 'star',
            'hm hm-step-flow' => 'step-flow',
            'hm hm-steps' => 'steps',
            'hm hm-stop-watch' => 'stop-watch',
            'hm hm-stop' => 'stop',
            'hm hm-support-call' => 'support-call',
            'hm hm-tab' => 'tab',
            'hm hm-table-lamp' => 'table-lamp',
            'hm hm-tablet' => 'tablet',
            'hm hm-tag' => 'tag',
            'hm hm-target-arrow' => 'target-arrow',
            'hm hm-target' => 'target',
            'hm hm-target1' => 'target1',
            'hm hm-team-carousel' => 'team-carousel',
            'hm hm-team-member' => 'team-member',
            'hm hm-tennis-ball' => 'tennis-ball',
            'hm hm-terminal' => 'terminal',
            'hm hm-testimonial-carousel' => 'testimonial-carousel',
            'hm hm-testimonial' => 'testimonial',
            'hm hm-text-animation' => 'text-animation',
            'hm hm-theatre' => 'theatre',
            'hm hm-tick-circle' => 'tick-circle',
            'hm hm-tick' => 'tick',
            'hm hm-tickets' => 'tickets',
            'hm hm-tie-knot' => 'tie-knot',
            'hm hm-tie' => 'tie',
            'hm hm-timeline' => 'timeline',
            'hm hm-toggle' => 'toggle',
            'hm hm-tools' => 'tools',
            'hm hm-tree-square' => 'tree-square',
            'hm hm-twitter-bird' => 'twitter-bird',
            'hm hm-twitter' => 'twitter',
            'hm hm-ufo' => 'ufo',
            'hm hm-umbralla' => 'umbralla',
            'hm hm-unlock' => 'unlock',
            'hm hm-up-down' => 'up-down',
            'hm hm-upload' => 'upload',
            'hm hm-upward-top-right' => 'upward-top-right',
            'hm hm-user-female' => 'user-female',
            'hm hm-user-id' => 'user-id',
            'hm hm-user-male' => 'user-male',
            'hm hm-video-camera' => 'video-camera',
            'hm hm-water-drop' => 'water-drop',
            'hm hm-weather-cloud-day' => 'weather-cloud-day',
            'hm hm-weather-cloud' => 'weather-cloud',
            'hm hm-weather-day-rain' => 'weather-day-rain',
            'hm hm-weather-day-snow' => 'weather-day-snow',
            'hm hm-weather-day-windy-rain' => 'weather-day-windy-rain',
            'hm hm-weather-flood' => 'weather-flood',
            'hm hm-weather-night-cloud' => 'weather-night-cloud',
            'hm hm-weather-rain-alt' => 'weather-rain-alt',
            'hm hm-weather-rain' => 'weather-rain',
            'hm hm-weather-snow' => 'weather-snow',
            'hm hm-weather-sun-rain' => 'weather-sun-rain',
            'hm hm-weather-sun' => 'weather-sun',
            'hm hm-weather-sunny-day' => 'weather-sunny-day',
            'hm hm-weather-thunder' => 'weather-thunder',
            'hm hm-weather-windy-rain' => 'weather-windy-rain',
            'hm hm-webcam1' => 'webcam1',
            'hm hm-webcam2' => 'webcam2',
            'hm hm-weight-scale' => 'weight-scale',
            'hm hm-windows' => 'windows',
            'hm hm-wine-glass2' => 'wine-glass2',
            'hm hm-wine-glass' => 'wine-glass',
            'hm hm-worker-cap' => 'worker-cap',
            'hm hm-youtube' => 'youtube',
            'hm hm-centralize' => 'centralize',
            'hm hm-add-section' => 'add-section',
            'hm hm-advanced-heading' => 'advanced-heading',
            'hm hm-air-baloon' => 'air-baloon',
            'hm hm-arrow2' => 'arrow2',
            'hm hm-bicycle2' => 'bicycle2',
            'hm hm-bond2' => 'bond2',
            'hm hm-bond3' => 'bond3',
            'hm hm-bond4' => 'bond4',
            'hm hm-calendar2' => 'calendar2',
            'hm hm-carousel' => 'carousel',
            'hm hm-code-page' => 'code-page',
            'hm hm-comment-circle' => 'comment-circle',
            'hm hm-comment-square' => 'comment-square',
            'hm hm-copy' => 'copy',
            'hm hm-cursor' => 'cursor',
            'hm hm-envelop2' => 'envelop2',
            'hm hm-factory' => 'factory',
            'hm hm-finger-point' => 'finger-point',
            'hm hm-finger-swipe-both' => 'finger-swipe-both',
            'hm hm-finger-swipe-corner' => 'finger-swipe-corner',
            'hm hm-finger-swipe-left' => 'finger-swipe-left',
            'hm hm-finger-swipe-up' => 'finger-swipe-up',
            'hm hm-finger-swipe' => 'finger-swipe',
            'hm hm-finger-touch' => 'finger-touch',
            'hm hm-folder-sync' => 'folder-sync',
            'hm hm-graph-bar2' => 'graph-bar2',
            'hm hm-graph-pie2' => 'graph-pie2',
            'hm hm-heading-h' => 'heading-h',
            'hm hm-heading-html' => 'heading-html',
            'hm hm-heart' => 'heart',
            'hm hm-home2' => 'home2',
            'hm hm-indent-left' => 'indent-left',
            'hm hm-indent-right' => 'indent-right',
            'hm hm-lock-close' => 'lock-close',
            'hm hm-lock-open' => 'lock-open',
            'hm hm-map-pointer-add' => 'map-pointer-add',
            'hm hm-map-pointer-check' => 'map-pointer-check',
            'hm hm-map-pointer-delete' => 'map-pointer-delete',
            'hm hm-map-pointer2' => 'map-pointer2',
            'hm hm-map' => 'map',
            'hm hm-navigation1' => 'navigation1',
            'hm hm-navigation2' => 'navigation2',
            'hm hm-page-export' => 'page-export',
            'hm hm-page-sync' => 'page-sync',
            'hm hm-piramid' => 'piramid',
            'hm hm-plug' => 'plug',
            'hm hm-point-marker' => 'point-marker',
            'hm hm-quote2' => 'quote2',
            'hm hm-refresh-check' => 'refresh-check',
            'hm hm-refresh' => 'refresh',
            'hm hm-refresh2' => 'refresh2',
            'hm hm-scrolling-image' => 'scrolling-image',
            'hm hm-sign-turn-right' => 'sign-turn-right',
            'hm hm-speedometer' => 'speedometer',
            'hm hm-sticky' => 'sticky',
            'hm hm-sync-cloud' => 'sync-cloud',
            'hm hm-sync' => 'sync',
            'hm hm-sync2' => 'sync2',
            'hm hm-table-lamp2' => 'table-lamp2',
            'hm hm-target2' => 'target2',
            'hm hm-timeline-spiral' => 'timeline-spiral',
            'hm hm-tv' => 'tv',
            'hm hm-vespa' => 'vespa',
            'hm hm-happyaddons' => 'happyaddons',
        ];
    }
}

Icons_Manager::init();
